#version 330

#define Epsilon 1e-5 
#define Step 0.11111111111111111111111111111111
#define Offset 0.01388888888888888888888888888889
#define Width 0.08333333333333333333333333333333

uniform sampler2DArray texArray;
uniform sampler2DArray matArrayA;
uniform sampler2DArray matArrayB;
uniform sampler2D groundNoise;

uniform float shininess;
uniform vec4 lightPosition;
#ifndef GBUFFER
uniform vec4 ambient;
#else
uniform float farClip;
#endif
uniform vec4 invGroundNoiseSize;

in vec4 pos;
in vec3 norm;
in vec4 uv;
in vec4 vertexColor;
in vec4 worldPos;
in vec3 tang;
in vec3 binorm;

#ifdef GBUFFER
out vec4 oColor0;
out vec4 oColor1;
#else
out vec4 oColor;
#endif

vec3 expand(vec2 v) {
	vec3 nor;
	nor.xy = v*2.0 - 1.0;
	nor.z = sqrt(1.0 - dot(nor.xy, nor.xy));
	return nor;
}

vec2 encodeNormal(vec3 n)
{
    float p = sqrt(n.z*8 + 8);
    return vec2(n.xy/p + 0.5);
}

void main() 
{
	vec2 uvTex = worldPos.xy*0.25;
	vec2 dx = dFdx(uvTex);
	vec2 dy = dFdy(uvTex);
	
	vec4 mat0 = textureLod(matArrayA, uv.xyz, 0);
	vec4 mat1 = textureLod(matArrayB, uv.xyz, 0);
	
	float matWArr[8];
	
	vec4 matW = vec4(1,0,0,0);
	ivec4 matI = ivec4(8,0,0,0);
	
	int i, j;
	int t = 0;
	float f;
	
	for(i = 0; i < 4; ++i) {
		matWArr[i] = mat0[i];
		matWArr[i+4] = mat1[i];
	}
	
	for(j = 1; j < 4; ++j) {
		for(i = 0; i < 8; ++i) {
			if(matWArr[i] > matW[j]) {
				matW[j] = matWArr[i];
				matI[j] = i;
				t = i;
			}
		}
		matWArr[t] = 0.0;
	}
	
	if(matI.z < matI.y) {
		matI = matI.xzyw;
		matW = matW.xzyw;
	}
	if(matI.w < matI.y) {
		matI = matI.xwzy;
		matW = matW.xwzy;
	}
	if(matI.w < matI.z) {
		matI = matI.xywz;
		matW = matW.xywz;
	}
	
	vec3 N = normalize(norm.xyz);
	vec4 color;

	vec4 diffuse = vec4(0,0,0,0);
	vec4 nor_spec = vec4(0,0,0,0);
	
	for(i = 0; i < 4; ++i) {
		color = textureGrad(texArray, vec3(uvTex, matI[i]), dx, dy);
		f = min(2.0*color.a*matW[i], 1);
		diffuse = mix(diffuse, color, f);
		
		nor_spec = mix(nor_spec, textureGrad(texArray, vec3(uvTex, matI[i] + 9), dx, dy), f);
	}
	diffuse *= textureLod(groundNoise, worldPos.xy*invGroundNoiseSize.xy*0.25, 0)*0.5 + 0.5;
	diffuse *= vertexColor;
	
	vec3 nor_ts = expand(nor_spec.ag);
	N = normalize(tang*nor_ts.x + binorm*nor_ts.y + norm*nor_ts.z);

#ifdef GBUFFER
	oColor0 = vec4(encodeNormal(N), pos.z/farClip, 0.0);
	oColor1 = vec4(diffuse.rgb, nor_spec.r);
#else
	vec3 LightDir = normalize(lightPosition.xyz);
	float NdotL = dot(LightDir, N);
	vec3 EyeDir = normalize(-pos.xyz);
	float Rim = pow(1 - abs(dot(EyeDir, N)), 2)*0.5;
	vec3 HalfAngle = normalize(LightDir + EyeDir);
	float NdotH = dot(HalfAngle, N);
	vec4 Lit = vec4(1.0, max(NdotL, 0.0), (NdotL > 0) ? pow(max(0.0, NdotH), 73.1707) : 0, 1.0);
	
	oColor = vec4(clamp(diffuse.rgb*(ambient.rgb + vec3(Lit.y)) + vec3(nor_spec.r*(Lit.z + Rim)), 0.0, 10.0), 1.0);
#endif
}
